/**
 * Beschrijft een harnas van een ridderpersonage van een computergame.
 *
 * @author Dominiek Vandewalle
 * @version 2015-06-30
 */
public class Harnas
{
   private String type;
   private double beschermingsfactor;//getal tussen 0 (geen bescherming)
                                    //en 1(totale bescherming)
   
   /**
   * Constructor voor objecten van de klasse Harnas.
   * @param type                Het type van het harnas.
   * @param beschermingsfactor  De mate waarin het harnas de ridder beschermt.
   */
   public Harnas(String type, double beschermingsfactor)
   {
       this.type = type;
       this.beschermingsfactor = beschermingsfactor;
   }
   
   /**
    * Geeft de beschermingsfactor van het harnas terug.
    * @return   De beschermingsfactor van het harnas.
    */
   public double getBeschermingsfactor()
   {
       return beschermingsfactor;
   }
   
   /**
    * Geeft het type van het harnas terug.
    * @return   Het type van het harnas.
    */
   public String getType()
   {
       return type;
   }
   
   /**
    * Geeft informatie over type en beschermingsfactor van het harnas terug.
    * @return   Info over het harnas.
    */
   public String toString()
   {
       return type + " -> beschermingsfactor = " + beschermingsfactor;
   }
}